function b = concatenan(varargin)
% b = concatenan(a1, a2, a3, ...)
% Concatenates all columns (or column-like matrices) in one matrix, adding NAN in the end as necessary.

% Rev. May 23 2012

n = nargin;

l = 0; % Length
m = 0;
for(q=1:n)
    l = max(l,size(varargin{q},1));
    m = m+size(varargin{q},2);
end

b = nan(l,m);

i = 1;
for(q=1:n)
    t = varargin{q};
    b(1:size(t,1),i:(i+size(t,2)-1)) = t;
    i = i+size(t,2);
end

end
